------------------------------------------------------------------------------
-- reload All Fuses, Revision: 1.00
--
-- composition script
--
-- This script scans the entire composition for Fuse tools, and reloads the
-- tool, exactly as if the artist had clicked on the Reload button in the tool 
-- controls. It is useful for making sure all tools are current without requiring that
-- the entire composition be reloaded.
-- 
-- Note that name of tools affected by this script will change after it has run.
--
-- written by : Isaac Guenard (izyk@eyeonline.com)
-- written    : July 13th, 2007
-- requires   : Fusion 5.2 or later 
--
------------------------------------------------------------------------------

-- get all tools
toollist = comp:GetToolList()

-- for each tool
for i, tool in ipairs(toollist) do
  -- if tool has a ScriptReload control, go ahead and click on it.
  if tool.ScriptReload then
    tool.ScriptReload[TIME_UNDEFINED] = 1
  end
end
